#!/usr/bin/env python
# -*- coding: utf-8 -*- 
#   Gimp-Python - allows the writing of Gimp plugins in Python.
#   Copyright (C) 1997  James Henstridge <james@daa.com.au>
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#   Źródło: https://raw.githubusercontent.com/goblin/gimp/master/plug-ins/pygimp/plug-ins/sphere.py 
#   
import math   # moduł math zawiera deklaracje wielu przydatnych funkcji matematycznych
              #wtyczka importuje biblioteki math Pythona, ponieważ stosuje kilka podstaw 
              # trygonometrii i wykorzystuje wartość pi. 
from gimpfu import *  # mówi Pythonowi skąd ma załadować moduły GIMP 

def sphere(radius, light, shadow, bg_colour, sphere_colour):
    if radius < 1:
        radius = 1
    # Oblicza rozmiar płótna. int(wartość) zamienia liczby zmiennoprzecinkowe 
	# na liczby całkowite
    width = int(radius * 3.75)
    height = int(radius * 2.5)

    gimp.context_push() # Zapisujemy aktualny kolor pierwszoplanowy, aby móc z niego skorzystać potem:

    img = gimp.Image(width, height, RGB)

    drawable = gimp.Layer(img, "Sphere Layer", width, height,
                          RGB_IMAGE, 100, NORMAL_MODE)  # Layer jest obiektem tworzącym nową warstwę 

    radians = light * math.pi / 180

    cx = width / 2
    cy = height / 2

    light_x = cx + radius * 0.6 * math.cos(radians)
    light_y = cy - radius * 0.6 * math.sin(radians)

    light_end_x = cx + radius * math.cos(math.pi + radians)
    light_end_y = cy - radius * math.sin(math.pi + radians)

    offset = radius * 0.1

    img.disable_undo()
    img.insert_layer(drawable) # procedura poprawiona - warstwa dodawana do obrazu…

    gimp.set_foreground(sphere_colour) # Ustawiamy kolor na ten, który przekazujemy do funkcji

    gimp.set_background(bg_colour)
    pdb.gimp_edit_fill(drawable, BACKGROUND_FILL)  # ...i wypełnia kolorem 

    gimp.set_background(20, 20, 20)
    # stosowane poniżej operatory i ich znaczenie były opisane
    if (light >= 45 and light <= 75 or light <= 135 and   
        light >= 105) and shadow:
        shadow_w = radius * 2.5 * math.cos(math.pi + radians)
        shadow_h = radius * 0.5
        shadow_x = cx
        shadow_y = cy + radius * 0.65

        if shadow_w < 0:
            shadow_x = cx + shadow_w
            shadow_w = -shadow_w

        pdb.gimp_ellipse_select(img, shadow_x, shadow_y, shadow_w, shadow_h,
                                CHANNEL_OP_REPLACE, True, True, 7.5)
        pdb.gimp_edit_bucket_fill(drawable, BG_BUCKET_FILL,
                                  MULTIPLY_MODE, 100, 0, False, 0, 0)

    pdb.gimp_ellipse_select(img, cx - radius, cy - radius, 2 * radius,
                            2 * radius, CHANNEL_OP_REPLACE, True, False, 0)
    pdb.gimp_edit_blend(drawable, FG_BG_RGB_MODE, NORMAL_MODE, GRADIENT_RADIAL,
                        100, offset, REPEAT_NONE, False, False, 0, 0, True,
                        light_x, light_y, light_end_x, light_end_y)

    pdb.gimp_selection_none(img)
    # procedura umożliwia cofnięcie stosu obrazu
    img.enable_undo()  
	
	# Jak na razie na ekranie nadal nic nie będzie, bo żaden obiekt nie został wywołany. 
	# Musimy zatem "uworzyć nowe okno obrazu na ekranie" wszystkie utworzone obiekty, 
	# czyli ten główny, na którym cały czas pracowaliśmy
    disp = gimp.Display(img)

    gimp.context_pop()  # Przywracamy "stary" kolor pierwszego planu:


register(
    "sphere",
    "Prosta kula z rzucanym cieniem",
    "Prosta kula z rzucanym cieniem",
    "James Henstridge, Modified Zbyma72age",
    "James Henstridge",
    "1997-1999, Modified 2015",
    "_Sphere...",
    "",
    [
        (PF_INT, "radius", "Promień kuli", 100),
        (PF_SLIDER, "light", "Kąt światła", 45, (0,360,1)),
        (PF_TOGGLE, "shadow", "Cień?", 1),        
        (PF_COLOR, "bg-color", "Tło", (1.0, 1.0, 1.0)),
        (PF_COLOR, "sphere-color", "Kula", "orange")
    ],
    [],
    sphere,  # Nazwa podana w def wywoływana Naszym kodem
    menu="<Image>/TEST/Testowanie" ) # ścieżkę do menu, można zmienić, wg własnego uznania

main()